package ftp;
/*
 * TP JAVA RIP
 * Min Serveur FTP
 * */

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;

public class Main {

	public static void main(String[] args) throws Exception {
		System.out.println("Le Serveur FTP");
		
		// Préparation des sockets et attente d'un utilisateur.
		ServerSocket serveurFTP = new ServerSocket(2222);
		// $$ System.out.println("-> 0");
		Socket socket = serveurFTP.accept();
		
		// $$ System.out.println("-> 1");
		
		// Définition de BufferedReader (lecteur des commandes du client) et PrintStream (transmetteur des réponses au client).
		BufferedReader br = new BufferedReader(new InputStreamReader(socket.getInputStream()));
		// $$ System.out.println("-> 2");
		PrintStream ps = new PrintStream(socket.getOutputStream());
		// $$ System.out.println("-> 3");
		
		ps.println("1 Bienvenue ! ");
		ps.println("1 Serveur FTP Personnel.");
		ps.println("0 Authentification : ");
		
		String commande = "";
		
		/* // Attente de reception de commandes et leur execution
		while(!(commande=br.readLine()).equals("bye")) {
			System.out.println(">> "+commande);
			CommandExecutor.executeCommande(ps, commande);
		} */
		
		// Attente de reception de commandes et leur execution.
		commande = br.readLine();
		
		// Tant que commande n'est pas "bye", exécuter les commandes reçues.
		while(!(commande).equals("bye")) {
			CommandExecutor.executeCommande(ps, commande);
			commande = br.readLine();
			System.out.println(">> "+commande);
		}
		
	    System.out.println("0 end");
		ps.println("0 end");
		
		
		// Fermeture des sockets.
		serveurFTP.close();
		socket.close();
	}

}
